package com.ejie.ab04b.util;

import java.util.List;

import com.ejie.ab04b.util.Utilities;

/**
 * 
 * @author GFI
 * 
 */
public final class UtilSQL {

	public final static String LIKE = "LIKE";
	public static final String VARIABLE = " ? ";
	public final static String IGUAL_VAR = " = ? ";
	public final static String NO_IGUAL_VAR = " != ? ";
	public final static String IGUAL = " = ";
	public final static String IN = " IN ";
	public final static String NOT_IN = " NOT IN ";
	public final static String IS_NULL = " IS NULL ";
	public final static String IS_NOT_NULL = " IS NOT NULL";
	public final static String VAR = " ? ";
	public final static String MAYOR_VAR = " > ? ";
	public final static String MAYOR_IGUAL_VAR = " >= ? ";
	public final static String MENOR_VAR = " < ? ";
	public final static String MENOR_IGUAL_VAR = " <= ? ";
	public final static String CONJUNCION_AND = " AND ";
	public final static String CONJUNCION_OR = " OR ";

	public final static String VOCALES_TRANSLATE_CONTILDE = "\u00C1\u00C9\u00CD\u00D3\u00DA";
	public final static String VOCALES_TRANSLATE_SINTILDE = "AEIOU";

	/**
	 * Constructor de UtilSQL.
	 */
	private UtilSQL() {
	}

	/**
	 * Metodo que prepara la sentencia de SQL para el campo.
	 * 
	 *  nombreCampo
	 *            String
	 *  valorCampo
	 *            Object
	 *  where
	 *            StringBuilder
	 *  params
	 *            List<Object>
	 *
	 * @param nombreCampo the nombre campo
	 * @param valorCampo the valor campo
	 * @param where the where
	 * @param params the params
	 */
	public static void preparaCampoSQL(final String nombreCampo,
			final Object valorCampo, StringBuilder where, List<Object> params) {

		if (valorCampo instanceof String
				&& ((String) valorCampo).trim().length() == 0) {
			return;
		}

		if (valorCampo instanceof String
				&& Utilities.getInstance().containsPatternLike(valorCampo)) {
			where.append(" AND ").append(UtilSQL.translateUpper(nombreCampo))
					.append(UtilSQL.LIKE).append(UtilSQL.translateUpper());

		} else {
			where.append(" AND ").append(nombreCampo).append(UtilSQL.IGUAL_VAR);
		}
		params.add(valorCampo);
	}

	/**
	 * Lo pasa a mayúsculas y quita las tildes
	 * 
	 * String para concatenarlo en las Select de BBDD.
	 * 
	 *  String
	 *
	 * @return the string
	 */
	public static String translateUpper() {
		return " TRANSLATE(UPPER(?),'ÁÉÍÓÚ','AEIOU') ";
	}

	/**
	 * Lo pasa a mayúsculas y quita las tildes.
	 * 
	 *  nombreCampo
	 *            a comparar
	 *  String en mayúsculas y sin tildes
	 *
	 * @param nombreCampo the nombre campo
	 * @return the string
	 */

	public static String translateUpper(final String nombreCampo) {
		return new StringBuffer().append(" TRANSLATE(UPPER(")
				.append(nombreCampo).append("),'ÁÉÍÓÚ','AEIOU') ").toString();
	}

	/**
	 * Lo pasa a mayúsculas y quita las tildes
	 * 
	 * String para concatenarlo en las Select de BBDD.
	 * 
	 *  valor
	 *            String
	 *  upper
	 *            boolean
	 *  String
	 *
	 * @param valor the valor
	 * @param upper the upper
	 * @return the string
	 */
	public static String comodinLike(String valor, boolean upper) {
		String valor_aux = valor;
		if (valor_aux == null) {
			valor_aux = "";
		}
		if (upper) {
			return "'%" + valor_aux.toUpperCase() + "%'";
		} else {
			return "'%" + valor_aux + "%'";
		}

	}

}